﻿#region << Using Directives >>
using System;
#endregion

namespace Volpe.Cafe.Generic
{
    /// <summary>
    /// Represents an object that stores compliance modeling data for each vehicle class. This object supports deep member cloning
    /// by requiring that each variable of this generic class implement the <see cref="ICloneable"/> interface.
    /// </summary>
    [Serializable]
    public class VCObject<T> : VCValue<T>, ICloneable where T : ICloneable
    {

        #region /*** Ctors ***/

        /// <summary>
        /// Initializes a new instance of the <see cref="VCObject{T}"/> class.
        /// </summary>
        public VCObject() : base() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="VCObject{T}"/> class using the specified values.
        /// </summary>
        public VCObject(T ldv, T ldt12a, T ldt2b3) : base(ldv, ldt12a, ldt2b3) { }

        #endregion

        #region /*** Methods ***/

        #region /* ICloneable Members */

        /// <summary>
        /// Creates a copy of the current <see cref="VCObject{T}"/> instance.
        /// </summary>
        /// <returns>A new object that is a copy of this <see cref="VCObject{T}"/>.</returns>
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        /// <summary>
        /// Creates a copy of the current <see cref="VCObject{T}"/> instance.
        /// </summary>
        /// <returns>A new object that is a copy of this <see cref="VCObject{T}"/>.</returns>
        public new VCObject<T> Clone()
        {
            VCObject<T> value = new VCObject<T>();
            this.CopyTo(value);
            return value;
        }
        /// <summary>
        /// Copies the members of the current <see cref="VCObject{T}"/> instance into the specified value.
        /// </summary>
        /// <param name="value">The value where to copy the members of the current instance.</param>
        protected void CopyTo(VCObject<T> value)
        {
            for (int i = 0; i < this.Items.Length; i++)
            {
                value.Items[i] = (T)this.Items[i].Clone();
            }
        }

        #endregion

        #endregion

    }
}
